<div class="tab-pane fade" id="sendsticker" role="tabpanel">
  <div class="d-flex mb-3 gap-3">
    <div>
      <span class="badge bg-label-primary rounded-2 p-2">
        <i class="ti tabler-sticker icon-32px"></i>
      </span>
    </div>
    <div>
      <h4 class="mb-0 lh-sm">
        <span class="align-middle">Send Sticker API</span>
      </h4>
      <small>Api Docs Sending Sticker Messages</small>
    </div>
  </div>
  <div id="accordionPayment" class="accordion">
    <div class="card">
      <div class="card-body">
        <p>Method : <code class="text-success">POST</code> | <code class="text-primary">GET</code></p>
        <p>Endpoint: <code><?php echo e(url('/')); ?>/send-sticker</code></p>

        <p>Request Body : (JSON If POST)</p>
        <table class="table">
          <thead>
            <tr>
              <th>Parameter</th>
              <th>Type</th>
              <th>Required</th>
              <th>Description</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>api_key</td>
              <td>string</td>
              <td>Yes</td>
              <td>API Key</td>
            </tr>
            <tr>
              <td>sender</td>
              <td>string</td>
              <td>Yes</td>
              <td>Number of your device</td>
            </tr>
            <tr>
              <td>number</td>
              <td>string</td>
              <td>Yes</td>
              <td>Recipient number ex 72888xxxx | 62888xxxx</td>
            </tr>
            <tr>
              <td>url</td>
              <td>string</td>
              <td>Yes</td>
              <td>Direct URL of sticker (image/gif → converted to webp)</td>
            </tr>
            <tr>
              <td>msgid</td>
              <td>string</td>
              <td>No</td>
              <td>Quoted message ID to reply to</td>
            </tr>
            <tr>
              <td>full</td>
              <td>number</td>
              <td>No</td>
              <td>Show full response from WhatsApp</td>
            </tr>
          </tbody>
        </table>

        <p>Note: Make sure the url is a direct link, not a shared link from Google Drive or other cloud storage.</p>
        <br>

        <h6>Example Without <code>full</code></h6>
        <p>JSON Request</p>
<pre class="bg-dark rounded text-white"><code>{
    "api_key": "1234567890",
    "sender": "62888xxxx",
    "number": "62888xxxx",
    "url": "https://example.com/image.jpg"
}</code></pre>

        <p>URL Request</p>
<pre class="bg-dark rounded text-white"><code><?php echo e(url('/')); ?>/send-sticker?api_key=1234567890&amp;sender=62888xxxx&amp;number=62888xxxx&amp;url=https://example.com/image.jpg</code></pre>

        <p>JSON Response</p>
<pre class="bg-dark rounded text-white"><code>{
    "status": true,
    "msg": "Message sent successfully!"
}</code></pre>

        <hr class="my-4">

        <h6>Example With <code>msgid</code> (reply)</h6>
        <p>JSON Request</p>
<pre class="bg-dark rounded text-white"><code>{
    "api_key": "1234567890",
    "sender": "62888xxxx",
    "number": "62888xxxx",
    "url": "https://example.com/image.jpg",
    "msgid": "3EB031F83D74BF480052B9"
}</code></pre>

        <p>URL Request</p>
<pre class="bg-dark rounded text-white"><code><?php echo e(url('/')); ?>/send-sticker?api_key=1234567890&amp;sender=62888xxxx&amp;number=62888xxxx&amp;url=https://example.com/image.jpg&amp;msgid=3EB031F83D74BF480052B9</code></pre>

        <hr class="my-4">

        <h6>Example With <code>full</code></h6>
        <p>JSON Request</p>
<pre class="bg-dark rounded text-white"><code>{
    "api_key": "1234567890",
    "sender": "62888xxxx",
    "number": "62888xxxx",
    "url": "https://example.com/image.jpg",
    "full": 1
}</code></pre>

        <p>URL Request</p>
<pre class="bg-dark rounded text-white"><code><?php echo e(url('/')); ?>/send-sticker?api_key=1234567890&amp;sender=62888xxxx&amp;number=62888xxxx&amp;url=https://example.com/image.jpg&amp;full=1</code></pre>

        <p>JSON Response</p>
<pre class="bg-dark rounded text-white"><code>{
  "status": true,
  "data": {
    "key": {
      "remoteJid": "62888xxxx@c.us",
      "fromMe": true,
      "id": "3EB08D898XXXXXXXXXXXX"
    },
    "message": {
      "stickerMessage": {
        "url": "https://mmg.whatsapp.net/o1/v/t24/f2/m234/AQNYq76feCY7f3iqD-ZyhEXxYrureD5rMxprf7mdRvldS52vXvVsGCCyPastQHDRHvK2DRrjhq3-MIzmgvhvXXXXXXXXXXXXXXXXX...",
        "mimetype": "image/webp"
      }
    },
    "messageTimestamp": "1755629964"
  }
}</code></pre>
      </div>
    </div>
  </div>
</div>
<?php /**PATH /home/codemall/a.codemall.store/resources/themes/vuexy/views/pages/api-docs/send-sticker.blade.php ENDPATH**/ ?>